---
title: AI Crawl Control with Cloudflare WAF · Cloudflare AI Crawl Control docs
description: AI Crawl Control works alongside other Cloudflare products, such as
  Cloudflare Web Application Firewall (WAF). WAF checks incoming web and API
  requests, and filters undesired traffic based on rules. WAF custom rules allow
  you to perform certain actions such as enforcing robots.txt.
lastUpdated: 2025-09-17T08:17:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ai-crawl-control/configuration/ai-crawl-control-with-waf/
  md: https://developers.cloudflare.com/ai-crawl-control/configuration/ai-crawl-control-with-waf/index.md
---

AI Crawl Control works alongside other Cloudflare products, such as Cloudflare [Web Application Firewall (WAF)](https://developers.cloudflare.com/waf/). WAF checks incoming web and API requests, and filters undesired traffic based on rules. [WAF custom rules](https://developers.cloudflare.com/waf/custom-rules/) allow you to perform certain actions such as enforcing `robots.txt`.

## Order of precedence

* AI Crawl Control uses WAF custom rules to block the selection of AI crawlers the site owner has decided to block.
* AI Crawl Control's pay per crawl feature takes place after WAF.

```mermaid
graph LR
A[Traffic] --> B[WAF custom rules<br>AI Crawl Control: Crawler blocks]
B --> C[Cloudflare<br>Bot Solutions]
C --> D[AI Crawl Control:<br>Pay Per Crawl]
classDef highlight fill:#F6821F,color:white
```

For this reason, if you plan on using AI Crawl Control to manage AI crawlers, you may wish to modify your existing WAF custom rules such that it does not affect AI crawlers. This will allow you to manage AI crawlers only from AI Crawl Control, thereby streamlining your workflow.

How AI Crawl Control uses WAF custom rules

When you block AI crawlers via AI Crawl Control (either all or some), you are using **one** WAF custom rule to block those AI crawlers.

If you choose to allow all AI crawlers, AI Crawl Control does not utilize any WAF custom rules.

Depending on the type of account you have, you may have a limited number of WAF custom rules.

## Examples of using WAF vs AI Crawl Control

Consider the following examples.

### Traffic from a restricted country vs pay per crawl

You may have both of the following features enabled:

* [WAF custom rule to block traffic from specific countries](https://developers.cloudflare.com/waf/custom-rules/use-cases/block-traffic-from-specific-countries/)
* AI Crawl Control's [pay per crawl](https://developers.cloudflare.com/ai-crawl-control/features/pay-per-crawl/what-is-pay-per-crawl/) to charge AI crawlers when they request access to your content

Since WAF custom rules are enforced before pay per crawl, traffic (including AI crawlers) from your blocked countries will continue to be blocked, even if they provide the [required headers](https://developers.cloudflare.com/ai-crawl-control/features/pay-per-crawl/use-pay-per-crawl-as-ai-owner/crawl-pages/#1-include-required-headers) for pay per crawl.

### Allowed search engine bots via WAF custom rule vs pay per crawl

You may have both of the following features enabled:

* [WAF custom rule to allow search engine bots](https://developers.cloudflare.com/waf/custom-rules/use-cases/allow-traffic-from-verified-bots/)
* AI Crawl Control's [pay per crawl](https://developers.cloudflare.com/ai-crawl-control/features/pay-per-crawl/what-is-pay-per-crawl/) to charge all AI crawlers when they request access to your content (including search engine bots).

Since custom rules are enforced before pay per crawl:

* Only search engine bots will be able to access your site (enforced by custom rule).
* The search engine bots will then be charged for access to your content (enforced by AI Crawl Control's pay per crawl).

Note

This example only serves to highlight the order of precedence between WAF and AI Crawl Control.

Practically, it may be beneficial to allow well-behaved search engine bots to access your content to ensure your content is indexed.

### Conflict in AI crawler blocking logic

You may have both of the following features enabled:

* A WAF custom rule which blocks all bots.
* AI Crawl Control selection which allows certain AI crawlers.

In this scenario, you have two custom rules, each directing a different logic for handling AI crawlers. To resolve this issue:

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **WAF** > **Custom rules** tab.
  3. Identify your WAF custom rule and the AI Crawl Control rule.
  4. Drag the rule you wish to prioritize to the top, or modify your WAF custom rule to ensure it does not conflict with your AI Crawl Control configurations.

* New dashboard

  1. In the Cloudflare dashboard, go to the **Security rules** page.

     [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules)

  2. Filter by *Custom rules*.

  3. Identify your custom rule and the AI Crawl Control rule.

  4. Drag the rule you wish to prioritize to the top, or modify your custom rule to ensure it does not conflict with your AI Crawl Control configurations.
