---
title: Set up address maps · Cloudflare BYOIP docs
description: Consider the sections below to learn how to set up address maps.
lastUpdated: 2025-09-04T17:04:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/byoip/address-maps/setup/
  md: https://developers.cloudflare.com/byoip/address-maps/setup/index.md
---

Consider the sections below to learn how to set up address maps.

Note

There is **no expected downtime** when setting up or updating your address maps.

## Create address maps

To avoid any errors if you have [static IPs](https://developers.cloudflare.com/byoip/concepts/static-ips/), Cloudflare creates an address map during the static IP onboarding process, meaning you cannot create a new address map with your static IPs. You may only edit the Cloudflare-created map and add or edit your zones within the existing map.

If you are using BYOIP instead, refer to the following steps:

1. In the Cloudflare dashboard, go to the **Address Maps** page.

   [Go to **Address maps**](https://dash.cloudflare.com/?to=/:account/ip-addresses/proxy-ips)

2. Select **Create an address map**.

3. Choose the scope of the address map.

4. Add the zones and IP addresses that you want to map.

5. Name your address map.

6. Review the information and select **Save and Deploy**.

Note

Creating an address map does not automatically change DNS configuration. DNS responses only begin to change when a zone or account is added to a map. Additionally, address maps that are not yet enabled will not take effect in DNS responses.

## Manage address maps

1. In the Cloudflare dashboard, go to the **Address Maps** page.

   [Go to **Address maps**](https://dash.cloudflare.com/?to=/:account/ip-addresses/proxy-ips)

2. Go to your address map and select **Review**.

3. Edit your address map.

4. Review the information and select **Save**.

Note

You can also enable, disable, and delete address maps. This will likely change the IP addresses used for your zones.

## Non-SNI support

If your visitors use devices that have not been updated since 2011, they may not have Server Name Indication (SNI) support. For further context, refer to [browser compatibility](https://developers.cloudflare.com/ssl/reference/browser-compatibility/#non-sni-support).

Use address maps to specify a hostname as default SNI. This will be used whenever Cloudflare receives a non-SNI TLS handshake.

Note

Setting up a default SNI is currently only supported via API.

1. If you have not already, create an address map. Refer to the [section above](#create-address-maps) or to the [Create Address Map](https://developers.cloudflare.com/api/resources/addressing/subresources/address_maps/methods/create/) API endpoint.
2. Take note of the address map `id`. If needed, you can use the [List Address Maps](https://developers.cloudflare.com/api/resources/addressing/subresources/address_maps/methods/list/) endpoint to get it.
3. Make sure you add the desired IPs to the address map. Cloudflare will respond with the default SNI on those IPs. Use the dashboard or refer to [Add An IP To An Address Map](https://developers.cloudflare.com/api/resources/addressing/subresources/address_maps/subresources/ips/methods/update/).
4. Configure the `default_sni` value on the address map created in step 1. Refer to the [Update Address Map](https://developers.cloudflare.com/api/resources/addressing/subresources/address_maps/methods/edit/) API endpoint for details. The default SNI can be any valid domain or subdomain owned by your account.

### Spectrum HTTPS applications

Default SNI for Spectrum can only be created via API using the [Create Address Map](https://developers.cloudflare.com/api/resources/addressing/subresources/address_maps/methods/create/) endpoint.

Do not include any membership in your command. Your API command should resemble the following:

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Address Maps Write`

```bash
curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/addressing/address_maps" \
  --request POST \
  --header "X-Auth-Email: $CLOUDFLARE_EMAIL" \
  --header "X-Auth-Key: $CLOUDFLARE_API_KEY" \
  --json '{
    "description": "default_sni",
    "default_sni": "sni.example.com",
    "enabled": false,
    "ips": [
        "192.0.0.1"
    ],
    "memberships": []
  }'
```
