---
title: Troubleshoot Transform Rules · Cloudflare Rules docs
description: When troubleshooting a rule configuration, review the Transform
  Rules evaluation section to understand how and when your Transform Rule is
  evaluated for each request.
lastUpdated: 2025-11-11T11:19:11.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/transform/troubleshooting/
  md: https://developers.cloudflare.com/rules/transform/troubleshooting/index.md
---

When troubleshooting a rule configuration, review the [Transform Rules evaluation](https://developers.cloudflare.com/rules/transform/#transform-rules-evaluation) section to understand how and when your Transform Rule is evaluated for each request.

For more information on runtime errors related to Transform Rules configuration, refer to [Troubleshooting Cloudflare 1XXX errors](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/).

## Why do I not see my request header modifications?

Transform Rules performing request header modifications affect the HTTP headers sent by Cloudflare's network to your origin server. You will not find these headers in your browser request or response data, which can make it difficult to tell if the rule is working as intended.

To check if a request header transform rule is taking effect, you can check the logs on your origin server or use [Cloudflare Trace](https://developers.cloudflare.com/rules/trace-request/) to check that the rule is matching traffic correctly. Since [Cloudflare Logpush](https://developers.cloudflare.com/logs/logpush/) only logs original HTTP request/response headers, Logpush logs will not include any header transformations done via Transform Rules.

To add HTTP headers that website visitors will receive in their browsers, you must [modify the response headers](https://developers.cloudflare.com/rules/transform/response-header-modification/) instead.
